
KJE.Default.TaxRate=24;KJE.Default.TaxRateRetire=22;KJE.Default.TaxRateCapGain=15;KJE.Default.StateTaxRate=8;KJE.Default.IncomeTaxTableCurrent="Use the &lsquo;Filing Status and Federal Income Tax Rates on Taxable Income&rsquo; table to assist you in estimating your Federal tax rate.<div class='KJEReportTableDiv'><table class='KJEReportTable KJEReportTableShrink'><caption class='KJEHeaderRow KJEHeading'>Filing Status and Federal Income Tax Rates on Taxable Income for 2024<sup>*</sup></caption><thead class='KJEReportTHeader'><tr class=KJEHeaderRow><th scope='col' class='KJEHeading KJECell10'>Tax Rate</th><th scope='col' class='KJEHeading KJECell225'>Married Filing Jointly or Qualified Surviving Spouse</th><th scope='col' class='KJEHeading KJECell225'>Single</th><th scope='col' class='KJEHeading KJECell225'>Head of Household</th><th scope='col' class='KJEHeading KJECell225'>Married Filing Separately</th></tr></thead><tbody class='KJEReportTBody'><tr class='KJEOddRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>10%</th><td class='KJECell KJECellBorder'>$0 -&nbsp;$23,200</td><td class='KJECell KJECellBorder'>$0 -&nbsp;$11,600</td><td class='KJECell KJECellBorder'>$0 -&nbsp;$16,550</td><td class='KJECell KJECellBorder'>$0 -&nbsp;$11,600</td></tr><tr class='KJEEvenRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>12%</th><td class='KJECell KJECellBorder'>$23,200 -&nbsp;$94,300</td><td class='KJECell KJECellBorder'>$11,600 -&nbsp;$47,150</td><td class='KJECell KJECellBorder'>$16,550 -&nbsp;$63,100</td><td class='KJECell'>$11,600 -&nbsp;$47,150</td></tr><tr class='KJEOddRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>22%</th><td class='KJECell KJECellBorder'>$94,300 -&nbsp;$201,050</td><td class='KJECell KJECellBorder'>$47,150 -&nbsp;$100,525</td><td class='KJECell KJECellBorder'>$63,100 -&nbsp;$100,500</td><td class='KJECell'>$47,150 -&nbsp;$100,525</td></tr><tr class='KJEEvenRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>24%</th><td class='KJECell KJECellBorder'>$201,050 -&nbsp;$383,900</td><td class='KJECell KJECellBorder'>$100,525 -&nbsp;$191,950</td><td class='KJECell KJECellBorder'>$100,500 -&nbsp;$191,950</td><td class='KJECell'>$100,525 -&nbsp;$191,950</td></tr><tr class='KJEOddRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>32%</th><td class='KJECell KJECellBorder'>$383,900 -&nbsp;$487,450</td><td class='KJECell KJECellBorder'>$191,950 -&nbsp;$243,725</td><td class='KJECell KJECellBorder'>$191,950 -&nbsp;$243,700</td><td class='KJECell'>$191,950 -&nbsp;$243,725</td></tr><tr class='KJEEvenRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>35%</th><td class='KJECell KJECellBorder'>$487,450 -&nbsp;$731,200</td><td class='KJECell KJECellBorder'>$243,725 -&nbsp;$609,350</td><td class='KJECell KJECellBorder'>$243,700 -&nbsp;$609,350</td><td class='KJECell'>$243,725 -&nbsp;$365,600</td></tr><tr class='KJEOddRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>37%</th><td class='KJECell KJECellBorder'>Over &nbsp;$731,200</td><td class='KJECell KJECellBorder'>Over &nbsp;$609,350</td><td class='KJECell KJECellBorder'>Over &nbsp;$609,350</td><td class='KJECell'>Over &nbsp;$365,600</td></tr></tbody><tfoot class='KJEReportTFooter'><tr class=KJEFooterRow><td class='KJECell KJECenterText' COLSPAN='5'><sup>*</sup>Caution: Do not use these tax rate schedules to figure 2023 taxes. Use only to figure 2024 estimates. Source: Rev. Proc. 2023-34</td></tr></tfoot></table></div>";KJE.Default.StandardDeductionCurrent="<div class='KJEReportTableDiv'><table class='KJEReportTable'><caption class='KJEHeaderRow KJEHeading'>Standard Deduction for 2024 Federal Income Tax</caption><thead class='KJEReportTHeader'><tr class=KJEHeaderRow><th scope='col' class='KJEHeading KJECell60'>Filing Status</th><th scope='col' class='KJEHeading KJECell40'>Standard Deduction</th></tr></thead><tbody class='KJEReportTBody'><tr class='KJEOddRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>Married Filing Joint</th><td class='KJECell'>$29,200</td></tr><tr class='KJEEvenRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>Qualified Surviving Spouse</th><td class='KJECell'>$29,200</td></tr><tr class='KJEOddRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>Single</th><td class='KJECell'>$14,600</td></tr><tr class='KJEEvenRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>Heads of Household</th><td class='KJECell'>$21,900</td></tr><tr class='KJEOddRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>Married Filing Separately</th><td class='KJECell'>$14,600</td></tr></tbody></table></div><p>Your standard deduction is increased if you or your spouse are blind or over age 65.";KJE.Default.CapitalGainsRatesCurrent="Long-term capital gains are taxed at lower, special capital gains rates and are calculated as follows (note that qualified dividends are taxed as if they were a long-term capital gain):<ul><li>Calculate your total taxable income without long-term capital gains. </li><li>Use this amount to determine the rate for your long-term gain, up to the top of the bracket.</li><li>The portion of your long-term capital gain that exceeds a bracket will be taxed at the next higher rate.</li><li>This calculator assumes that none of your long-term capital gains come from collectibles, section 1202 gains or un-recaptured 1250 gains.  These types of capital gains are taxed at 28%, 28% and 25% respectively (unless your ordinary income tax bracket is a lower rate).</li></ul><div class='KJEReportTableDiv'><table class='KJEReportTable KJEReportTableShrink'><caption class='KJEHeaderRow KJEHeading'>Long-term Capital Gain Tax Rates 2024<sup>*</sup></caption><thead class='KJEReportTHeader'><tr class=KJEHeaderRow><th scope='col' class='KJEHeading'>Tax Rate</th><th scope='col' class='KJEHeading KJECell225'>Married Filing Jointly or Qualified Surviving Spouse</th><th scope='col' class='KJEHeading KJECell225'>Single</th><th scope='col' class='KJEHeading KJECell225'>Head of Household</th><th scope='col' class='KJEHeading KJECell225'>Married Filing Separately</th></tr></thead><tbody class='KJEReportTBody'><tr class='KJEOddRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>0%</th><td class='KJECell KJECellBorder'>$0 -&nbsp;$94,050</td><td class='KJECell KJECellBorder'>$0 -&nbsp;$47,025</td><td class='KJECell KJECellBorder'>$0 -&nbsp;$63,000</td><td class='KJECell'>$0 -&nbsp;$47,025</td></tr><tr class='KJEEvenRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>15%</th><td class='KJECell KJECellBorder'>$94,050 -&nbsp;$583,750</td><td class='KJECell KJECellBorder'>$47,025 -&nbsp;$518,900</td><td class='KJECell KJECellBorder'>$63,000 -&nbsp;$551,350</td><td class='KJECell'>$47,025 -&nbsp;$291,850</td></tr><tr class='KJEOddRow'><th scope='row' class='KJELabel KJECellBorder KJELabelPad'>20%</th><td class='KJECell KJECellBorder'>Over $583,750</td><td class='KJECell KJECellBorder'>Over $518,900</td><td class='KJECell KJECellBorder'>Over $551,350</td><td class='KJECell'> Over $291,850</td></tr></tbody><tfoot class='KJEReportTFooter'><tr class=KJEFooterRow><td class='KJECell KJECenter' COLSPAN='5'><sup>*</sup>Caution: Do not use these tax rate schedules to figure 2023 taxes. Use only to figure 2024 estimates. Source: Rev. Proc. 2023-34</td></tr></tfoot></table></div>";KJE.Default.IncomeTaxTableTaxYear=KJE.Default.IncomeTaxTableCurrent;KJE.Default.StandardDeductionTaxYear=KJE.Default.StandardDeductionCurrent;KJE.Default.CapitalGainsRatesTaxYear=KJE.Default.CapitalGainsRatesCurrent;KJE.definitions.set("**TAXCAPGAINS_CURRENT_DEFINITION**",KJE.Default.CapitalGainsRatesCurrent);KJE.definitions.set("**TAXCAPGAINS_TAXYEAR_DEFINITION**",KJE.Default.CapitalGainsRatesTaxYear);KJE.definitions.set("**TAXTABLE_CURRENT_DEFINITION**",KJE.Default.IncomeTaxTableCurrent);KJE.definitions.set("**TAXTABLE_TAXYEAR_DEFINITION**",KJE.Default.IncomeTaxTableTaxYear);KJE.definitions.set("**STANDARDDEDUCTION_CURRENT_DEFINITION**",KJE.Default.StandardDeductionCurrent);KJE.definitions.set("**STANDARDDEDUCTION_TAXYEAR_DEFINITION**",KJE.Default.StandardDeductionTaxYear);KJE.MortgageRentvsBuyCalc=function(){this.PROVINCE_SELECTED=-1;this.GROSS_SALE_TAX=0;this.GST_TOTAL_REBATE=0;this.HST_TOTAL_REBATE=0;this.MAINTENANCE=0;this.bUSE_FLEX=false;this.OTHER_CLOSING_COSTS_RATE=0;this.USE_OTHER_FEES_AMOUNT=true;this.LOAN_ORIGINATION_AMT=0;this.PROPERTY_TAX_AMT=0;this.ANNUAL_REPORT_PERIOD=true;this.GST_TAX=0;this.GST_TAX_USE=false;this.TOTAL_CMHC=0;this.RATE_CMHC=0;this.LOAN_TO_VALUE=0;this.TOTAL_ACTUAL_CMHC=0;this.bMORTGAGE_INSURANCE=true;this.PMI_RATE=KJE.parameters.get("PMI_RATE",0.5);this.MONTHLY_PMI=KJE.parameters.getSet("MONTHLY_PMI",0);this.PMI_CALCULATE=KJE.parameters.get("PMI_CALCULATE",true);this.PMI_PERCENTAGE=KJE.parameters.get("PMI_PERCENTAGE",0.2);this.oldLOAN_AMOUNT=0;this.oldDOWNPAYMENT_20=0;this.CMHC_SHOW_ALL_RATES=KJE.parameters.get("CMHC_SHOW_ALL_RATES",false);this.USE_OTHER_FEES_AMOUNT=KJE.parameters.get("USE_OTHER_FEES_AMOUNT",true);this.MSG_RESULT1=KJE.parameters.get("MSG_RESULT1","Your home purchase breaks even in approximately BREAKEVEN_YEARS years.");this.MSG_DESC1=KJE.parameters.get("MSG_DESC1","If you cannot remain in your home for at least BREAKEVEN_YEARS years you should consider continuing to rent.");this.MSG_RESULT2=KJE.parameters.get("MSG_RESULT2","Your home purchase does not break even after LENGTH_OF_LOAN years.");this.MSG_DESC2=KJE.parameters.get("MSG_DESC2","Your home purchase does not break even after LENGTH_OF_LOAN years. You should consider continuing to rent.");this.MSG_ERROR1=KJE.parameters.get("MSG_ERROR1","You do not have enough cash on hand to cover your closing costs.");var a=this.CAMORTGAGE=KJE.parameters.get("CAMORTGAGE",false);this.MSG_REMAINING_CASH=KJE.parameters.get("MSG_REMAINING_CASH","Remaining cash");this.MSG_LOAN_ORIGINATION_RATE=KJE.parameters.get("MSG_LOAN_ORIGINATION_RATE",a?"Mortgage fee":"Loan origination");this.MSG_POINTS_PAID_NBR=KJE.parameters.get("MSG_POINTS_PAID_NBR","Points paid");this.MSG_OTHER_CLOSING_COSTS=KJE.parameters.get("MSG_OTHER_CLOSING_COSTS","Other closing costs");this.MSG_GRAPH3=KJE.parameters.get("MSG_GRAPH3","Net house payment");this.MSG_GRAPH4=KJE.parameters.get("MSG_GRAPH4","Rent payment");this.MSG_GRAPH5=KJE.parameters.get("MSG_GRAPH5","Monthly Payment Breakdown");this.MSG_GRAPH6=KJE.parameters.get("MSG_GRAPH6","House payment");this.MSG_GRAPH7=KJE.parameters.get("MSG_GRAPH7","Initial tax savings");this.MSG_GRAPH8=KJE.parameters.get("MSG_GRAPH8","Initial principal payment");this.DS_RENT=null;this.DS_INVESTMENT_TOTAL=null;this.DS_PMI=null;this.DS_EQUITY=null;this.DS_EQUITY_AFTER_COSTS=null;this.DS_INTEREST=null;this.DS_INSURANCE=null;this.DS_TAXES=null;this.DS_PROPERTY_TAXES=null;this.DS_MONTHLY_TOTAL_PMT=null;this.DS_NET_HOME_COST=null;this.DS_HOME_VALUE=null;this.DS_HOME_EQUITY=null;this.sCat4=new Array((a?4:5));this.DS_G4=KJE.FloatArray((a?4:5));this.cats2=new Array((a?4:5));this.DS_G2=KJE.FloatArray((a?4:5));this.sSchedule=new KJE.Repeating()};KJE.MortgageRentvsBuyCalc.prototype.clear=function(){this.PRICE_OF_HOME=0;this.MAXIMUM_20_DOWN=false;this.DOWNPAYMENT_CLOSING_CASH=0;this.PROPERTY_TAX_RATE=0;this.HOME_INSURANCE_RATE=0;this.INTEREST_RATE=0;this.LENGTH_OF_LOAN=0;this.LOAN_ORIGINATION_RATE=0;this.POINTS_PAID_NBR=0;this.OTHER_CLOSING_COSTS=0;this.TAX_RATE=0;this.MONTHLY_RENT=0;this.INFLATION_RATE=0;this.INVESTMENT_RETURN=0;this.HOME_APPRECIATION_RATE=0;this.HOME_COMMISION_RATE=0};KJE.MortgageRentvsBuyCalc.prototype.calculate=function(S){var d=KJE;var N=this.PRICE_OF_HOME;var A=this.DOWNPAYMENT_CLOSING_CASH;var aa=this.PROPERTY_TAX_RATE;var F=this.HOME_INSURANCE_RATE;var c=this.INTEREST_RATE;var L=this.LENGTH_OF_LOAN;var C=this.LOAN_ORIGINATION_RATE;var j=this.POINTS_PAID_NBR;var g=this.OTHER_CLOSING_COSTS;var h=this.TAX_RATE;var a=this.MONTHLY_RENT;var t=this.INFLATION_RATE;var x=this.INVESTMENT_RETURN;var H=this.HOME_APPRECIATION_RATE;var s=this.HOME_COMMISION_RATE;var b=0;var P=0;var G=0;var I=this.MONTHLY_PMI;var J=0;var z=false;var f=N/2;var v=N;var V=0;var Z=0;var u=N*this.PMI_PERCENTAGE;var ac=this.CAMORTGAGE;if(ac){this.ENTERED_INTEREST_RATE=c;c=(Math.pow(1+(c/200),(1/6))-1)*1200}this.GST_TAX=0;if(ac){var U=KJE.Default.getGST(this.GST_TAX_USE,N,this.PROVINCE_SELECTED);this.GST_TAX=U.N;this.GROSS_SALE_TAX=U.G;this.GST_TOTAL_REBATE=U.R1;this.HST_TOTAL_REBATE=U.R2}while(z==false){this.LOAN_ORIGINATION_AMT=(ac?this.LOAN_ORIGINATION_AMT:v*(C/100));if(!this.USE_OTHER_FEES_AMOUNT){g=d.round((this.OTHER_CLOSING_COSTS_RATE/100)*v,2)}b=v*(j/100);P=this.GST_TAX+b+this.LOAN_ORIGINATION_AMT+g;G=A-P;if((G>u)&&(this.MAXIMUM_20_DOWN==1)&&(!ac)){G=u}if(ac){v=N-G;this.RATE_CMHC=KJE.Default.getCMHCRate(v,G,N,this.bUSE_FLEX,L,this.CMHC_SHOW_ALL_RATES);this.TOTAL_ACTUAL_CMHC=v*this.RATE_CMHC;this.RATE_CMHC=(this.bMORTGAGE_INSURANCE?this.RATE_CMHC:0);this.TOTAL_CMHC=v*this.RATE_CMHC;v=v+this.TOTAL_CMHC}else{this.RATE_CMHC=0;this.TOTAL_CMHC=0}Z=v+G-this.TOTAL_CMHC;if(Math.round(N*1000)==Math.round(Z*1000)){z=true}else{if(N>Z){v+=f}else{v-=f}}if(v<0){v=0}f=(f/2);V++;if(V>50){z=true}}if(G<(ac?KJE.Default.DownpaymentForPurchasePrice(N):0)){throw (KJE.getKJEReplaced(this.MSG_ERROR1,ac?d.dollars(KJE.Default.DownpaymentForPurchasePrice(N),0):""))}if(v==0){G=N}if(ac){I=0}else{if(this.PMI_CALCULATE&&(u!=this.oldDOWNPAYMENT_20||v!=this.oldLOAN_AMOUNT)){if(u>G){I=v*(this.PMI_RATE/1200)}else{I=0}}this.oldLOAN_AMOUNT=v;this.oldDOWNPAYMENT_20=u}var O=N*(F/100);if(!ac){this.PROPERTY_TAX_AMT=N*(aa/100)}var E=O/12;var af=this.PROPERTY_TAX_AMT/12;var p=P+u;var ag=d.round(KJE.PMT(c/1200,L*12,v),2);var r=af+E+ag+I+this.MAINTENANCE;var e=Math.round(L);var ad=0;this.DS_RENT=KJE.FloatArray(e);this.DS_INVESTMENT_TOTAL=KJE.FloatArray(e);this.DS_PMI=KJE.FloatArray(e);this.DS_EQUITY=KJE.FloatArray(e);this.DS_INTEREST=KJE.FloatArray(e);this.DS_INSURANCE=KJE.FloatArray(e);this.DS_TAXES=KJE.FloatArray(e);this.DS_PROPERTY_TAXES=KJE.FloatArray(e);this.DS_MONTHLY_TOTAL_PMT=KJE.FloatArray(e);this.DS_NET_HOME_COST=KJE.FloatArray(e);this.DS_HOME_VALUE=KJE.FloatArray(e);this.DS_HOME_EQUITY=KJE.FloatArray(e);this.DS_EQUITY_AFTER_COSTS=KJE.FloatArray(e);this.cats=["1","2","3","4","5","6","7","8","9","10"];if(S){var D=this.sSchedule;var o=(this.ANNUAL_REPORT_PERIOD?D.sReportCol("<br/>Year",7):D.sReportCol("<br/>Nbr",1));D.clearRepeat();D.addHeader(o,D.sReportCol("House<br />Payment (PITI)",2),(ac?"":D.sReportCol("Payment<br />After-Tax Savings",3)),D.sReportCol("Rent<br />Payment",4),D.sReportCol("Value of<br />Investment",5),D.sReportCol("Home<br />Equity",6))}var Y=0;var q=0;var y=0;var w=0;var B=0;var T=0;var R=a;var m=G+P;var l=E;var ah=af;var M=N-v;var W=N;var Q=this.MAINTENANCE;var ab=KJE.ROR_MONTH(x/100);var K=v;var k=(W-K)-(W*s/100);var ae=(W*(H/1200));ad=0;for(var X=1;X<=e*12;X++){if(((X-1)%12)==0&&X!=1){R*=(1+(t/100));l=W*(F/1200);Q*=(1+(t/100));if(ac){ah*=(1+(t/100))}else{ah=W*(aa/1200)}ae=(W*(H/1200))}y=d.round(c/1200*K,2);q=ag-y;K-=q;if(K<0){K=0;q=ag-K-y}if(e*12==X){if(K>0.005){K=0;q=ag+K-y}else{K=0}}if(!ac&&u>(N-K)){if(this.PMI_CALCULATE){Y=v*(this.PMI_RATE/1200)}else{Y=I}}else{Y=0}B=l+ah+y+q+Y+Q;w=(y+ah)*(h/100);m=m*(1+ab)+(B-R-w);T=B-w-q;W+=ae;M=W-K;k=M-(W*s/100);if(J==0){if(k>m){J=(X)/12}}this.DS_RENT[ad]=R;this.DS_PMI[ad]=Y;this.DS_EQUITY[ad]=q;this.DS_INTEREST[ad]=y;this.DS_INSURANCE[ad]=l;this.DS_TAXES[ad]=w;this.DS_PROPERTY_TAXES[ad]=ah;this.DS_MONTHLY_TOTAL_PMT[ad]=B;this.DS_NET_HOME_COST[ad]=T;this.DS_HOME_VALUE[ad]=(W);this.DS_HOME_EQUITY[ad]=(M);this.DS_EQUITY_AFTER_COSTS[ad]=(k);this.DS_INVESTMENT_TOTAL[ad]=(m<0?0:m);if(((X-1)%12)==0&&X!=1){ad++}if(((X%12)==0)||!this.ANNUAL_REPORT_PERIOD){if(S){D.addRepeat((this.ANNUAL_REPORT_PERIOD?ad+1:X),d.dollars(B,2),(ac?"":d.dollars(T+q,2)),d.dollars(R,2),d.dollars(m),d.dollars(k))}}}this.HOME_INSURANCE_AMT=O;this.POINTS_PAID_AMT=b;this.TOTAL_CLOSING_COSTS=P;this.TOTAL_FOR_DOWNPAYMENT=G;this.LOAN_AMOUNT=v;this.DOWNPAYMENT_20=u;this.CLOSING_CLOSING_COSTS_20=p;this.HOME_INSURANCE_MONTHLY=E;this.PROPERY_TAX_MONTHLY=af;this.MONTHLY_PI=ag;this.MONTHLY_PMI=I;this.MONTH_PMI_EXEMPT=(G>=u);this.MONTHLY_TOTAL_PMT=r;this.BREAKEVEN_YEARS=J;X=0;this.DS_G4[X]=this.TOTAL_FOR_DOWNPAYMENT;this.sCat4[X++]=this.MSG_DOWNPAYMENT+" "+d.dollars(this.TOTAL_FOR_DOWNPAYMENT);this.DS_G4[X]=this.LOAN_ORIGINATION_AMT;this.sCat4[X++]=this.MSG_LOAN_ORIGINATION_RATE+" "+d.dollars(this.LOAN_ORIGINATION_AMT);if(!ac){this.DS_G4[X]=this.POINTS_PAID_AMT;this.sCat4[X++]=this.sCat4[2]=this.POINTS_PAID_NBR+" "+d.dollars(this.POINTS_PAID_AMT)}this.DS_G4[X]=this.OTHER_CLOSING_COSTS;this.sCat4[X++]=this.MSG_OTHER_CLOSING_COSTS+" "+d.dollars(this.OTHER_CLOSING_COSTS);this.DS_G4[X]=(this.DOWNPAYMENT_CLOSING_CASH-this.TOTAL_CLOSING_COSTS-this.TOTAL_FOR_DOWNPAYMENT);this.sCat4[X]=this.MSG_REMAINING_CASH+" "+d.dollars(this.DOWNPAYMENT_CLOSING_CASH-this.TOTAL_CLOSING_COSTS-this.TOTAL_FOR_DOWNPAYMENT);this.RESULT_MESSAGE_MAIN=this.MSG_RESULT2;if(this.BREAKEVEN_YEARS>0&&this.BREAKEVEN_YEARS<=this.LENGTH_OF_LOAN){this.RESULT_MESSAGE_MAIN=this.MSG_RESULT1}this.RESULT_MESSAGE_MAIN=KJE.replace("BREAKEVEN_YEARS",d.number(this.BREAKEVEN_YEARS,1),this.RESULT_MESSAGE_MAIN);this.RESULT_MESSAGE_MAIN=KJE.replace("LENGTH_OF_LOAN",d.number(this.LENGTH_OF_LOAN),this.RESULT_MESSAGE_MAIN);X=0;this.cats2[X++]=this.MSG_GRAPH4+" "+d.dollars(this.DS_RENT[0]);this.cats2[X++]=this.MSG_GRAPH6+" "+d.dollars(this.DS_MONTHLY_TOTAL_PMT[0]);if(!ac){this.cats2[X++]=this.MSG_GRAPH7+" "+d.dollars(this.DS_TAXES[0])}this.cats2[X++]=this.MSG_GRAPH8+" "+d.dollars(this.DS_EQUITY[0]);this.cats2[X++]=this.MSG_GRAPH3+" "+d.dollars(this.DS_NET_HOME_COST[0]);X=0;this.DS_G2[X++]=this.DS_RENT[0];this.DS_G2[X++]=this.DS_MONTHLY_TOTAL_PMT[0];if(!ac){this.DS_G2[X++]=this.DS_TAXES[0]}this.DS_G2[X++]=this.DS_EQUITY[0];this.DS_G2[X++]=this.DS_NET_HOME_COST[0]};KJE.MortgageRentvsBuyCalc.prototype.formatReport=function(a){a.replace("MSG_INSURANCE_NOT_INCLUDED",(this.TOTAL_CMHC==this.TOTAL_ACTUAL_CMHC?"":KJE.Default.MSG_INSURANCE_NOT_INCLUDED));if(this.BREAKEVEN_YEARS>0&&this.BREAKEVEN_YEARS<=this.LENGTH_OF_LOAN){a.replace("RESULT_MESSAGE_MAIN",this.MSG_RESULT1);a.replace("RESULT_MESSAGE_ADVICE",this.MSG_DESC1)}else{a.replace("RESULT_MESSAGE_MAIN",this.MSG_RESULT2);a.replace("RESULT_MESSAGE_ADVICE",this.MSG_DESC2)}a.dollars("PRICE_OF_HOME",this.PRICE_OF_HOME);a.yesno("MAXIMUM_20_DOWN",this.MAXIMUM_20_DOWN);a.dollars("DOWNPAYMENT_CLOSING_CASH",this.DOWNPAYMENT_CLOSING_CASH);a.taxRate("PROPERTY_TAX_RATE",this.PROPERTY_TAX_RATE/100);if(!this.GST_TAX_USE){a.replace("SALES_TAX_EXPLANATION_EXTRA","");a.replace("SALES_TAX_EXPLANATION","")}else{if(this.PROVINCE_SELECTED>=0){a.replace("SALES_TAX_EXPLANATION_EXTRA",KJE.Default.SALES_TAX_EXPLANATION_EXTRA[this.PROVINCE_SELECTED]);a.replace("SALES_TAX_EXPLANATION",KJE.Default.SALES_TAX_EXPLANATION);a.replace("PROVINCE_NAME",KJE.Default.PROVINCES[this.PROVINCE_SELECTED]);a.replace("SALE_TAX_TYPE",KJE.Default.SALE_TAX_TYPE[this.PROVINCE_SELECTED]);a.taxRate("SALE_TAX_RATE",KJE.Default.SALE_TAX_RATE[this.PROVINCE_SELECTED]);a.dollars("GROSS_SALE_TAX",this.GROSS_SALE_TAX);a.dollars("GST_TOTAL_REBATE",this.GST_TOTAL_REBATE);a.dollars("HST_TOTAL_REBATE",this.HST_TOTAL_REBATE);a.dollars("PURCHASE_PRICE",this.PRICE_OF_HOME)}else{a.replace("SALES_TAX_EXPLANATION_EXTRA","");a.replace("SALES_TAX_EXPLANATION",(KJE.Default.GST_SALES_TAX_EXPLAINATION?KJE.Default.GST_SALES_TAX_EXPLAINATION:""))}}a.replace("SALE_TAX_TYPE","GST");if(KJE.Default.GST_TAX_RATE){a.taxRate("GST_TAX_RATE",KJE.Default.GST_TAX_RATE)}else{a.replace("GST_TAX_RATE","")}a.taxRate("TAX_RATE",this.TAX_RATE/100);a.percent("HOME_INSURANCE_RATE",this.HOME_INSURANCE_RATE/100,3);a.loanRate("INTEREST_RATE",(this.CAMORTGAGE?this.ENTERED_INTEREST_RATE:this.INTEREST_RATE)/100);a.number("LENGTH_OF_LOAN",this.LENGTH_OF_LOAN);a.percent("LOAN_ORIGINATION_RATE",this.LOAN_ORIGINATION_RATE/100,3);a.number("POINTS_PAID_NBR",this.POINTS_PAID_NBR);a.percent("PMI_RATE",this.PMI_RATE/100,3);a.dollars("OTHER_CLOSING_COSTS",this.OTHER_CLOSING_COSTS);a.dollars("HOME_INSURANCE_AMT",this.HOME_INSURANCE_AMT);a.dollars("LOAN_ORIGINATION_AMT",this.LOAN_ORIGINATION_AMT);a.dollars("PROPERTY_TAX_AMT",this.PROPERTY_TAX_AMT);a.dollars("POINTS_PAID_AMT",this.POINTS_PAID_AMT);a.dollars("TOTAL_CLOSING_COSTS",this.TOTAL_CLOSING_COSTS+this.TOTAL_CMHC);a.dollars("TOTAL_FOR_DOWNPAYMENT",this.TOTAL_FOR_DOWNPAYMENT);a.dollars("LOAN_AMOUNT",this.LOAN_AMOUNT);a.dollars("DOWNPAYMENT_20",this.DOWNPAYMENT_20);a.dollars("CLOSING_CLOSING_COSTS_20",this.CLOSING_CLOSING_COSTS_20);a.dollars("HOME_INSURANCE_MONTHLY",this.HOME_INSURANCE_MONTHLY);a.dollars("PROPERY_TAX_MONTHLY",this.PROPERY_TAX_MONTHLY);a.dollars("MONTHLY_PI",this.MONTHLY_PI);a.dollars("MONTHLY_PMI",this.MONTHLY_PMI);a.dollars("TOTAL_CMHC",this.TOTAL_CMHC);a.percent("RATE_CMHC",this.RATE_CMHC,2);a.dollars("GST_TAX",this.GST_TAX);a.dollars("MONTHLY_TOTAL_PMT",this.MONTHLY_TOTAL_PMT);a.dollars("MONTHLY_TOTAL_PMT",this.MONTHLY_TOTAL_PMT);a.dollars("MAINTENANCE",this.MAINTENANCE);a.dollars("MONTHLY_RENT",this.MONTHLY_RENT);a.inflationRate("INFLATION_RATE",this.INFLATION_RATE/100);a.percent("INVESTMENT_RETURN",this.INVESTMENT_RETURN/100,2);a.percent("HOME_COMMISION_RATE",this.HOME_COMMISION_RATE/100,2);a.percent("HOME_APPRECIATION_RATE",this.HOME_APPRECIATION_RATE/100,2);a.year("BREAKEVEN_YEARS",this.BREAKEVEN_YEARS);a.dollars("TOTAL_ACTUAL_CMHC",this.TOTAL_ACTUAL_CMHC);if(this.CAMORTGAGE){a.dollars("REQUIRED_DOWNPAYMENT",KJE.Default.DownpaymentForPurchasePrice(this.PRICE_OF_HOME))}a.replace("**REPEATING GROUP**",this.sSchedule.getRepeat())};KJE.CalcName="Home Rent vs. Buy Calculator";KJE.CalcType="mortgagerentvsbuy";KJE.CalculatorTitleTemplate="KJE1";KJE.parseInputs=function(a){a=KJE.replace("**TERM**",KJE.getMortgageTermDrop("TERM",30),a);return a};KJE.initialize=function(){KJE.CalcControl=new KJE.MortgageRentvsBuyCalc();KJE.GuiControl=new KJE.MortgageRentvsBuy(KJE.CalcControl)};KJE.MortgageRentvsBuy=function(o){var g=KJE;var b=KJE.gLegend;var k=KJE.inputs.items;this.MSG_GRAPH12=KJE.parameters.get("MSG_GRAPH12","Home Equity vs. Investment");this.MSG_DOWNPAYMENT=KJE.parameters.get("MSG_DOWNPAYMENT","Down payment");var q=KJE.parameters.get("MSG_TOTAL_CLOSING_COSTS","Total closing costs: KJE1");var h=KJE.parameters.get("MSG_MONTHLY_TOTAL","Monthly house payment: KJE1");var c=KJE.parameters.get("MSG_MONTHLY_RENT_LBL","Monthly rent payment: KJE1");this.MSG_GRAPH1=KJE.parameters.get("MSG_GRAPH1","10 Year Projected Monthly Payments");this.MSG_GRAPH2=KJE.parameters.get("MSG_GRAPH2","Year");this.MSG_GRAPH9=KJE.parameters.get("MSG_GRAPH9","Investment total");this.MSG_GRAPH10=KJE.parameters.get("MSG_GRAPH10","Equity in home");this.MSG_GRAPH11=KJE.parameters.get("MSG_GRAPH11","Net sales price");KJE.MortgageAmtSlider("PRICE_OF_HOME","Purchase price");KJE.MortgageTermDropBoxSlider("TERM","Term in years");KJE.MortgageRateSlider("INTEREST_RATE","Interest rate");KJE.DollarSlider("DOWNPAYMENT_CLOSING_CASH","Cash on hand",0,10000000);KJE.PercentSlider("PROPERTY_TAX_RATE","Property tax rate",0,20,2);KJE.PercentSlider("HOME_INSURANCE_RATE","Home insurance",0,10,2);KJE.Label("LOAN_AMOUNT","Loan amount",null,null,"bold");KJE.Label("MONTHLY_PI","Monthly payment (PI)",null,null,"bold");KJE.Label("TOTAL_FOR_DOWNPAYMENT","Total down payment",null,null,"bold");KJE.DollarSlider("MAINTENANCE","Maintenance/Condo Fees",-10000,10000);KJE.PercentSlider("LOAN_ORIGINATION_RATE","Loan origination",0,5,3);KJE.NumberSlider("POINTS_PAID_NBR","Points paid",-4,8,3,0.5);if(o.USE_OTHER_FEES_AMOUNT){KJE.DollarSlider("OTHER_CLOSING_COSTS","Other closing costs",0,10000)}else{KJE.PercentSlider("OTHER_CLOSING_COSTS","Other closing costs",0,5,2)}KJE.PercentSlider("TAX_RATE","Income tax rate",0,50,2);KJE.DollarSlider("MONTHLY_RENT","Monthly rent payment",10,10000);KJE.DollarSlider("MONTHLY_PMI","Monthly PMI",0,1000,2);if(o.PMI_CALCULATE&&!KJE.parameters.get("PMI_SHOW",false)){k.MONTHLY_PMI.hide()}KJE.InflationRateSlider("INFLATION_RATE","Expected inflation",0,20,2);KJE.InvestRateSlider("INVESTMENT_RETURN","After-tax investment return");KJE.PercentSlider("HOME_APPRECIATION_RATE","Home appreciates at",-10,25,2,1);KJE.InvestRateSlider("HOME_COMMISION_RATE","Future sales commission");KJE.Checkbox("MAXIMUM20",KJE.getKJEReplaced(KJE.parameters.get("MSG_LABEL3","Limit down payment to KJE1"),g.percent(o.PMI_PERCENTAGE)));KJE.Radioboxes("YEAR","Report amortization",true,"Annually","Monthly");if(!KJE.parameters.get("SHOW_MAINTENANCE",false)){k.MAINTENANCE.setValue(0,true)}var j=KJE.gNewGraph(KJE.gLINE,"GRAPH3",true,false,KJE.colorList[1],KJE.parameters.get("MSG_GRAPH10",this.MSG_GRAPH12));j._legend._iOrientation=b.TOP_RIGHT;j._axisX.setVisible(true);j._titleYAxis.setText(KJE.sCurrency);j._titleXAxis.setText(this.MSG_GRAPH2);var m=KJE.gNewGraph(KJE.gCATEGORIES,"GRAPH2",true,true,KJE.colorList[1],KJE.parameters.get("MSG_GRAPH5","Monthly Payment Breakdown"));m._legend._iOrientation=b.TOP_RIGHT;m._axisX.setVisible(false);m._titleYAxis.setText("");m._titleXAxis.setText("");var i=KJE.gNewGraph(KJE.gCOLUMN,"GRAPH1",true,true,KJE.colorList[1],this.MSG_GRAPH1);i._iLimit=10;i._legend._iOrientation=b.TOP_RIGHT;i._titleYAxis.setText("");i._titleXAxis.setText(this.MSG_GRAPH2);var a=KJE.parameters.get("MSG_DROPPER_PAYMENT","Mortgage and Home Expenses:");var f=function(){return a+"|"+KJE.subText(KJE.getKJEReplaced(h,g.dollars(o.MONTHLY_TOTAL_PMT,2)),"KJERightBold")};KJE.addDropper(new KJE.Dropper("INPUTS",true,f,f),KJE.colorList[0]);var d=KJE.parameters.get("MSG_DROPPER_DOWNPAYMENT","Down Payment and Closing Costs:");var n=function(){return d+"|"+KJE.subText(KJE.getKJEReplaced(q,g.dollars(o.TOTAL_CLOSING_COSTS)),"KJERightBold")};KJE.addDropper(new KJE.Dropper("DOWNPAYMENT",false,n,n),KJE.colorList[0]);var p=KJE.parameters.get("MSG_DROPPER_RENT","Rent, Taxes and Inflation:");var e=function(){return p+"|"+KJE.subText(KJE.getKJEReplaced(c,g.dollars(o.MONTHLY_RENT)),"KJERightBold")};KJE.addDropper(new KJE.Dropper("RENT",false,e,e),KJE.colorList[0])};KJE.MortgageRentvsBuy.prototype.setValues=function(b){var a=KJE.inputs.items;b.MONTHLY_PMI=a.MONTHLY_PMI.getValue();b.PRICE_OF_HOME=a.PRICE_OF_HOME.getValue();b.DOWNPAYMENT_CLOSING_CASH=a.DOWNPAYMENT_CLOSING_CASH.getValue();b.PROPERTY_TAX_RATE=a.PROPERTY_TAX_RATE.getValue();b.HOME_INSURANCE_RATE=a.HOME_INSURANCE_RATE.getValue();b.INTEREST_RATE=a.INTEREST_RATE.getValue();b.LENGTH_OF_LOAN=a.TERM.getValue();b.LOAN_ORIGINATION_RATE=a.LOAN_ORIGINATION_RATE.getValue();b.LOAN_ORIGINATION_AMT=0;b.POINTS_PAID_NBR=a.POINTS_PAID_NBR.getValue();if(b.USE_OTHER_FEES_AMOUNT){b.OTHER_CLOSING_COSTS=a.OTHER_CLOSING_COSTS.getValue()}else{b.OTHER_CLOSING_COSTS_RATE=a.OTHER_CLOSING_COSTS.getValue()}b.TAX_RATE=a.TAX_RATE.getValue();b.MONTHLY_RENT=a.MONTHLY_RENT.getValue();b.INFLATION_RATE=a.INFLATION_RATE.getValue();b.INVESTMENT_RETURN=a.INVESTMENT_RETURN.getValue();b.HOME_APPRECIATION_RATE=a.HOME_APPRECIATION_RATE.getValue();b.HOME_COMMISION_RATE=a.HOME_COMMISION_RATE.getValue();b.ANNUAL_REPORT_PERIOD=a.YEAR.getValue();b.MAXIMUM_20_DOWN=a.MAXIMUM20.getValue();b.MAINTENANCE=a.MAINTENANCE.getValue()};KJE.MortgageRentvsBuy.prototype.refresh=function(g){var f=KJE;var e=KJE.gLegend;var b=KJE.inputs.items;var c=KJE.gGraphs[0];var d=KJE.gGraphs[1];var a=KJE.gGraphs[2];KJE.setTitleTemplate(g.RESULT_MESSAGE_MAIN);a.removeAll();a._iLimit=10;a.setGraphCategories(g.cats);a.add(new KJE.gGraphDataSeries(g.DS_NET_HOME_COST,g.MSG_GRAPH3,a.getColor(1),"",g.MSG_GRAPH3+" "+KJE.MSG_YEAR_LBL));a.add(new KJE.gGraphDataSeries(g.DS_RENT,g.MSG_GRAPH4,a.getColor(2),"",g.MSG_GRAPH4+" "+KJE.MSG_YEAR_LBL));a.paint();d.removeAll();d.setGraphCategories(g.cats2);d.add(new KJE.gGraphDataSeries(g.DS_G2,"",d.getColor(1)));d.paint();b.LOAN_AMOUNT.setText(f.dollars(g.LOAN_AMOUNT),true);b.MONTHLY_PI.setText(f.dollars(g.MONTHLY_PI,2),true);b.TOTAL_FOR_DOWNPAYMENT.setText(f.dollars(g.TOTAL_FOR_DOWNPAYMENT),true);c.removeAll();c._iLimit=10;c.setGraphCategories(g.cats);c.add(new KJE.gGraphDataSeries(g.DS_INVESTMENT_TOTAL,this.MSG_GRAPH9,a.getColor(1)));c.add(new KJE.gGraphDataSeries(g.DS_HOME_EQUITY,this.MSG_GRAPH10,a.getColor(2)));c.add(new KJE.gGraphDataSeries(g.DS_EQUITY_AFTER_COSTS,this.MSG_GRAPH11,a.getColor(3)));c.paint();b.MONTHLY_PMI.setValue(f.round(g.MONTHLY_PMI,2),true);if(g.MONTH_PMI_EXEMPT){b.MONTHLY_PMI.disable()}else{b.MONTHLY_PMI.enable()}};KJE.InputScreenText=" <div id=KJE-D-INPUTS><div id=KJE-P-INPUTS>Input information:</div></div> <div id=KJE-E-INPUTS > <div id='KJE-C-PRICE_OF_HOME'><input id='KJE-PRICE_OF_HOME' /></div> <div id='KJE-C-INTEREST_RATE'><input id='KJE-INTEREST_RATE' /></div> <div id='KJE-C-TERM'>**TERM**</div> <div id='KJE-C-MONTHLY_PMI'><input id='KJE-MONTHLY_PMI' /></div> <div id='KJE-C-LOAN_AMOUNT'><div id='KJE-LOAN_AMOUNT'></div></div> <div id='KJE-C-MONTHLY_PI'><div id='KJE-MONTHLY_PI'></div></div> <div class=KJEDropperSpacer></div> <div id='KJE-C-PROPERTY_TAX_RATE'><input id='KJE-PROPERTY_TAX_RATE' /></div> <div id='KJE-C-HOME_INSURANCE_RATE'><input id='KJE-HOME_INSURANCE_RATE' /></div> <div id='KJE-C-MAINTENANCE'><input id='KJE-MAINTENANCE' /></div> <div id='KJE-C-MONTHLY_TOTAL_PMT'><div id='KJE-MONTHLY_TOTAL_PMT'></div></div> <div id=\"KJE-C-YEAR\"><fieldset id='KJE-FS-YEAR'><input id=\"KJE-YEAR1\" type=radio name=YEAR /><input id=\"KJE-YEAR2\" type=radio name=YEAR /></fieldset></div> <div class=KJEDropperSpacer></div> </div> <div id=KJE-D-DOWNPAYMENT><div id=KJE-P-DOWNPAYMENT>Downpayment and closing costs</div></div> <div id=KJE-E-DOWNPAYMENT > <div id='KJE-C-DOWNPAYMENT_CLOSING_CASH'><input id='KJE-DOWNPAYMENT_CLOSING_CASH' /></div> <div id='KJE-C-LOAN_ORIGINATION_RATE'><input id='KJE-LOAN_ORIGINATION_RATE' /></div> <div id='KJE-C-POINTS_PAID_NBR'><input id='KJE-POINTS_PAID_NBR' /></div> <div id='KJE-C-OTHER_CLOSING_COSTS'><input id='KJE-OTHER_CLOSING_COSTS' /></div> <div id='KJE-C-TOTAL_FOR_DOWNPAYMENT'><div id='KJE-TOTAL_FOR_DOWNPAYMENT'></div></div> <div id='KJE-C-MAXIMUM20'><input id='KJE-MAXIMUM20' type=checkbox /></div> <div class=KJEDropperSpacer></div> </div> <div id=KJE-D-RENT><div id=KJE-P-RENT>Rent</div></div> <div id=KJE-E-RENT > <div id='KJE-C-MONTHLY_RENT'><input id='KJE-MONTHLY_RENT' /></div> <div id='KJE-C-INVESTMENT_RETURN'><input id='KJE-INVESTMENT_RETURN' /></div> <div id='KJE-C-TAX_RATE'><input id='KJE-TAX_RATE' /></div> <div id='KJE-C-INFLATION_RATE'><input id='KJE-INFLATION_RATE' /></div> <div id='KJE-C-HOME_APPRECIATION_RATE'><input id='KJE-HOME_APPRECIATION_RATE' /></div> <div id='KJE-C-HOME_COMMISION_RATE'><input id='KJE-HOME_COMMISION_RATE' /></div> <div class=KJEDropperSpacer></div> </div> **GRAPH3** **GRAPH2** **GRAPH1** ";KJE.DefinitionText=" <div id='KJE-D-PRICE_OF_HOME' ><dt>Price of home</dt><dd>Purchase price of the home you wish to buy.</dd></div> <div id='KJE-D-INTEREST_RATE' ><dt>Interest rate</dt><dd>The current interest rate you expect to receive on your mortgage. Please note that the interest rate is different from the Annual Percentage Rate (APR), which includes other expenses such as mortgage insurance, and the origination fee and or point(s), which were paid when the mortgage was first originated. The APR is normally higher than the simple interest rate.</dd></div> <div id='KJE-D-TERM' ><dt>Term in years</dt><dd>The number of years over which you will repay this loan.</dd></div> <div id='KJE-D-MONTHLY_PMI'><dt>Monthly PMI</dt><dd>Monthly cost of Private Mortgage Insurance (PMI). For loans secured with less than 20% down, PMI is estimated at 0.5% of your loan balance each year.</dd></div> <div id='KJE-D-LOAN_AMOUNT'><dt>Loan amount</dt><dd>Calculated amount of the loan for this home purchase.</dd></div> <div id='KJE-D-MONTHLY_PI' ><dt>Monthly payment (PI)</dt><dd>Monthly principal and interest (PI) payment.</dd></div> <div id='KJE-D-PROPERTY_TAX_RATE' ><dt>Property tax rate</dt><dd>Your property tax rate. 1% for a $100,000 home equals $1,000 per year in property taxes.</dd></div> <div id='KJE-D-HOME_INSURANCE_RATE' ><dt>Home insurance rate</dt><dd>Your homeowner's insurance rate. 0.5% for a $100,000 home equals $500 per year for homeowner's insurance.</dd></div> <div id='KJE-D-MAINTENANCE' ><dt>Association and maintenance fees</dt><dd>Any association fees you are required to pay per month with the ownership of this home. Also include any other maintenance costs you expect to incur with the ownership of this home that you are not paying while you continue to rent.</dd></div> <div id='KJE-D-DOWNPAYMENT_CLOSING_CASH' ><dt>Cash on hand</dt><dd>Cash you have for the down payment and closing costs.</dd></div> <div id='KJE-D-LOAN_ORIGINATION_RATE' ><dt>Loan origination rate</dt><dd>The percentage the lending institution charges for its origination fee. 1% for a $100,000 home equals $1,000.</dd></div> <div id='KJE-D-POINTS_PAID_NBR' ><dt>Points paid</dt><dd>The total number of points paid to reduce the interest rate of your mortgage. Each point costs 1% of your mortgage balance.</dd></div> <div id='KJE-D-OTHER_CLOSING_COSTS' ><dt>Other closing costs</dt><dd>Estimate of all other closing costs for this loan. This should include filing fees, appraiser fees and any other miscellaneous fees paid.</dd></div> <div id='KJE-D-TOTAL_FOR_DOWNPAYMENT' ><dt>Total for down payment</dt><dd>Total funds remaining for down payment.</dd></div> <div id='KJE-D-MONTHLY_RENT' ><dt>Monthly rent payment</dt><dd>Amount you currently pay for rent per month.</dd></div> <div id='KJE-D-INVESTMENT_RETURN' ><dt>After-tax investment return</dt><dd>The rate of return, after taxes, you could receive if you invested your closing costs and down payment instead of purchasing a home.<p>**ROR_DEFINITION**</dd></div> <div id='KJE-D-TAX_RATE' ><dt>Income tax rate</dt><dd>Your current marginal income tax rate. **TAXTABLE_CURRENT_DEFINITION**</dd></div> <div id='KJE-D-INFLATION_RATE' ><dt>Expected inflation rate</dt><dd>**INFLATION_DEFINITION** Inflation rate is used to adjust amounts subject to annual increases. These amounts include rent, insurance and tax payments.</dd></div> <div id='KJE-D-HOME_APPRECIATION_RATE' ><dt>Home value appreciation</dt><dd>Amount you expect your home value to appreciate annually.</dd></div> <div id='KJE-D-HOME_COMMISION_RATE' ><dt>Future sales commission</dt><dd>The percent of your home's selling price you expect to pay to a broker or real estate agent when you sell your home.</dd></div> <div id='KJE-D-MONTHLY_TOTAL_PMT' ><dt>House payment</dt><dd>Total of principal, interest, taxes and insurance (PITI) and maintenance paid per month for your home. Insurance includes Principal Mortgage Insurance (PMI) and homeowner's insurance.</dd></div> ";KJE.ReportText=' <!--HEADING "Rent vs. Buy" HEADING--> <h2 class=\'KJEReportHeader KJEFontHeading\'>RESULT_MESSAGE_MAIN</h2> The tool calculates your break even point by examining how long it would take to create enough equity in your home to exceed the value of investing your cash on hand as a renter. If your rent payment is less than your net house payment, the tool adds that monthly savings to your investment. If your house payment is less than your rent payment, the tool subtracts that amount from your investment. <p>(You may notice that on the schedule at the bottom of this report the investment value can be reported as negative. This happens if your house payment is significantly lower than your rent payment. It illustrates that if you continue to rent the extra cost of renting would, in effect, use up your cash on hand.) <p>When calculating equity, it is assumed your home will appreciate at HOME_APPRECIATION_RATE per year, and you have an income tax rate of TAX_RATE. The tool also subtracts a HOME_COMMISION_RATE sales commission paid to brokers or real estate agents when you sell your home. <p>RESULT_MESSAGE_ADVICE **GRAPH** <h2 class=\'KJEReportHeader KJEFontHeading\'>Estimated Loan Information</h2>Your total monthly payment was estimated at MONTHLY_TOTAL_PMT. Your down payment was estimated at TOTAL_FOR_DOWNPAYMENT and you had a home price of PRICE_OF_HOME. This is for a LENGTH_OF_LOAN-year mortgage with an interest rate of INTEREST_RATE in the amount of LOAN_AMOUNT. Your total closing costs for this loan are estimated at TOTAL_CLOSING_COSTS. <p> Your current monthly rent is MONTHLY_RENT. The expected inflation rate of INFLATION_RATE annually was used to estimate future rent and property taxes. The rate of return used for investments was INVESTMENT_RETURN per year after taxes. **GRAPH** <div class=KJEReportTableDiv><table class=KJEReportTable><caption class=\'KJEHeaderRow KJEHeading\'>Your MONTHLY_TOTAL_PMT monthly payment consists of:</caption> <tbody class=\'KJEReportTBody\'> <tr class=KJEOddRow><th class="KJELabel KJECellBorder KJECell60" scope=\'row\'>Principal and interest</th><td class="KJECell KJECell40">MONTHLY_PI</td></tr> <tr class=KJEEvenRow><th class="KJELabel KJECellBorder" scope=\'row\'>Monthly PMI</th><td class="KJECell">MONTHLY_PMI</td></tr> <tr class=KJEOddRow><th class="KJELabel KJECellBorder" scope=\'row\'>Taxes</th><td class="KJECell">PROPERY_TAX_MONTHLY</td></tr> <tr class=KJEEvenRow><th class="KJELabel KJECellBorder" scope=\'row\'>Insurance</th><td class="KJECell">HOME_INSURANCE_MONTHLY</td></tr> <tr class=KJEOddRow><th class="KJELabel KJECellBorder" scope=\'row\'>Association dues & maintenance</th><td class="KJECell">MAINTENANCE</td></tr> </tbody> </table> </div> <p> <div class=KJEReportTableDiv><table class=KJEReportTable><caption class=\'KJEHeaderRow KJEHeading\'>Closing costs estimate of TOTAL_CLOSING_COSTS consists of:</caption> <tbody class=\'KJEReportTBody\'> <tr class=KJEOddRow><th class="KJELabel KJECellBorder KJECell60" scope=\'row\'>Amount of points paid</th><td class="KJECell KJECell40">POINTS_PAID_AMT</td></tr> <tr class=KJEEvenRow><th class="KJELabel KJECellBorder" scope=\'row\'>Loan origination fee</th><td class="KJECell">LOAN_ORIGINATION_AMT</td></tr> <tr class=KJEOddRow><th class="KJELabel KJECellBorder" scope=\'row\'>Other closing costs</th><td class="KJECell">OTHER_CLOSING_COSTS</td></tr> </tbody> </table> </div> <p>To avoid PMI payments, a DOWNPAYMENT_20 down payment is required. This equals 20% of your home\'s purchase price. The total amount of cash required for a 20% down payment plus closing costs would be CLOSING_CLOSING_COSTS_20. <p>**GRAPH** <h2 class=\'KJEScheduleHeader KJEFontHeading\'>Analysis of Future Payments</h2> **REPEATING GROUP** ';

// 06/19/2024 Copyright 2024 KJE Computer Solutions, Inc.  Licensed for use on www.dinkytown.net


